// FontTextArea.java
// Jonas 24 jan
// Jonas 15 feb
import  java.applet.*;
import java.awt.*;

public class FontTextArea extends TextArea {
  
  private int lastTextPos = 0;
  private int startSel = 0, stopSel = 0;
  // Constructor for FontTextArea
  public FontTextArea(int rows, int columns, int scroll) {
    super("", rows, columns, scroll);
  }
  
  // Overriding append(), keeps old HighLite.  Also sets CaretPosition
  public void append( String text) {
    super.append(text);
    // setCaretPosition(getCaretPosition() + text.length());
    lastTextPos += text.length();
    select(startSel, stopSel);
    setCaretPosition(java.lang.Integer.MAX_VALUE);
    }
    // Appends- and HighLites text. Also sets CaretPosition
  public void appendHiLit( String text) {
    super.append(text);
    startSel = lastTextPos;
    stopSel = (lastTextPos += text.length());
    select(startSel, stopSel);
    // setCaretPosition(lastTextPos);
    setCaretPosition(java.lang.Integer.MAX_VALUE);
    }
}    


